<?php
require_once 'config.php';
requireLogin();

$orders = [];

try {
    $conn = getDBConnection();

    // Fetch all orders for the logged-in user
    $stmt = $conn->prepare("SELECT id, category, service_name, link, amount, notes, created_at, status FROM orders WHERE user_id = ? ORDER BY created_at DESC");
    if ($stmt === false) {
        throw new Exception('Prepare orders statement failed: ' . $conn->error);
    }
    $stmt->bind_param('i', $_SESSION['user_id']);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $orders[] = $row;
        }
    }
    $stmt->close();

} catch (Exception $e) {
    $error = 'حدث خطأ أثناء تحميل البيانات: ' . $e->getMessage();
}

require_once 'header.php';
?>

<div class="container mt-5">
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0">سجل الطلبات</h5>
        </div>
        <div class="card-body">
            <?php if (isset($error)): ?>
                <div class="alert alert-danger" role="alert">
                    <?= htmlspecialchars($error) ?>
                </div>
            <?php endif; ?>

            <div class="table-responsive">
                <table class="table table-hover table-striped">
                    <thead>
                        <tr>
                            <th>معرف الطلب</th>
                            <th>الفئة</th>
                            <th>الخدمة</th>
                            <th>الرابط</th>
                            <th>المبلغ</th>
                            <th>الملاحظات</th>
                            <th>تاريخ الطلب</th>
                            <th>الحالة</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($orders)): ?>
                            <?php foreach ($orders as $order): ?>
                            <tr>
                                <td><?= htmlspecialchars($order['id'] ?? 'N/A') ?></td>
                                <td><?= htmlspecialchars($order['category'] ?? 'N/A') ?></td>
                                <td><?= htmlspecialchars($order['service_name'] ?? 'N/A') ?></td>
                                <td><?= htmlspecialchars($order['link'] ?? 'N/A') ?></td>
                                <td><?= htmlspecialchars($order['amount'] ?? 'N/A') ?> $</td>
                                <td><?= htmlspecialchars($order['notes'] ?? 'N/A') ?></td>
                                <td><?= htmlspecialchars($order['created_at'] ?? 'N/A') ?></td>
                                <td>
                                    <span class="badge bg-<?= ($order['status'] ?? '') === 'completed' ? 'success' : (($order['status'] ?? '') === 'pending' ? 'warning' : 'danger') ?>">
                                        <?= htmlspecialchars($order['status'] ?? 'N/A') ?>
                                    </span>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="8" class="text-center">لا توجد طلبات لعرضها.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php require_once 'footer.php'; ?> 